<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">
            <h4 class="col-12 mb-1-9"><?php echo esc_html(get_field('infography_title', 'option')); ?>
                <svg class="header-line" width="178" height="7" viewBox="0 0 178 7" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <rect width="178" height="7" fill="#0189D0"/>
                </svg>
            </h4>

            <!-- Blog Right -->
            <div class="col-lg-6">
                <div class="row">
                    <?php
                    // Get the category ID from the 'infography' field
                    $infography_cat_id = get_field('infography', 'option');

                    // Query arguments for blog right
                    $blog_right_args = array(
                        'post_type' => 'post',
                        'cat' => $infography_cat_id,
                        'posts_per_page' => 4 // تعداد پست‌های مورد نمایش
                    );

                    // The Query for blog right
                    $blog_right_query = new WP_Query($blog_right_args);

                    // The Loop for blog right
                    if ($blog_right_query->have_posts()) {
                        while ($blog_right_query->have_posts()) {
                            $blog_right_query->the_post();
                            ?>
                            <div class="col-lg-6 mb-4">
                                <article class="blog-grid">
                                    <div class="blog-grid-img position-relative"><img class="main-part-img"
                                                                                      alt="<?php the_title_attribute(); ?>"
                                                                                      src="<?php echo get_the_post_thumbnail_url(); ?>">
                                    </div>
                                    <div class="blog-grid-text p-4">
                                        <h3 class="h5 blog-item-title m-0"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    </div>
                                </article>
                            </div>
                            <?php
                        }
                        /* Restore original Post Data */
                        wp_reset_postdata();
                    } else {
                        // no posts found
                    }
                    ?>
                </div>
            </div>
            <!-- End Blog Right -->

            <!-- Blog Left -->
            <div class="col-lg-6 mb-2-9 mb-lg-0">
                <?php
                // Get IDs of posts displayed in the right section
                $post_ids = array();
                while ($blog_right_query->have_posts()) {
                    $blog_right_query->the_post();
                    $post_ids[] = get_the_ID();
                }
                /* Restore original Post Data */
                wp_reset_postdata();

                // Query arguments for blog left
                $blog_left_args = array(
                    'post_type' => 'post',
                    'cat' => $infography_cat_id,
                    'posts_per_page' => 1, // تنها یک پست نمایش داده شود
                    'post__not_in' => $post_ids // Exclude posts displayed in the right section
                );

                // The Query for blog left
                $blog_left_query = new WP_Query($blog_left_args);

                // The Loop for blog left
                if ($blog_left_query->have_posts()) {
                    while ($blog_left_query->have_posts()) {
                        $blog_left_query->the_post();
                        ?>
                        <div class="blog-list-simple fadeInUp rtl wow" data-wow-delay=".2s">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="blog-list-simple-img"><img
                                                src="<?php echo get_the_post_thumbnail_url(); ?>"
                                                alt="<?php the_title_attribute(); ?>"></div>
                                    <div class="blog-list-simple-text">
                                        <h3 class="text-white"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p><?php echo get_the_excerpt() ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    /* Restore original Post Data */
                    wp_reset_postdata();
                } else {
                    // no posts found
                }
                ?>
            </div>
            <!-- End Blog Left -->

        </div>
    </div>
</section>
