<section class="pt-0 mt-10">
    <div class="container">
        <div class="w-md-75 w-lg-50 text-center mx-md-auto mb-6">
            <h2 class="line-title"><?php echo esc_html(get_field('video_title', 'option')); ?></h2>
        </div>
        <div class="row rtl">

            <?php
            $taxon = get_field('video_posts', 'option');
            // Get all posts for the category with ID 6 and order them by date
            $args_all = array(
                'post_type' => 'post',
                'posts_per_page' => 3,
                'cat' => $taxon, // Use the category ID here
                'orderby' => 'date',
                'order' => 'DESC',
            );

            $query_all = new WP_Query($args_all);

            // Check if there are any posts
            if ($query_all->have_posts()) :
                while ($query_all->have_posts()) : $query_all->the_post();
                    // Display slide for each post
                    ?>
                    <div class="col-lg-4 mb-4 mb-lg-0">
                        <article class="blog-item bg-grey rounded">
                            <div class="blog-item-thumbnail">
                                <img src="<?php echo get_the_post_thumbnail_url(); ?>"
                                     alt="<?php the_title_attribute(); ?>" class="img-fluid">
                            </div>
                            <div class="media align-items-center p-1-6">
                                <div class="blog-meta">
                                    <div class="date-day"><?php echo get_the_date('m'); ?></div>
                                    <div class="date-month"><?php echo get_the_date('Y'); ?></div>
                                </div>
                                <div class="media-body rtl">
                                    <div class="post-cat">
                                        <?php the_category(', '); ?>
                                    </div>
                                    <div class="blog-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        <a href="<?php the_permalink(); ?>" class="d-block read-more w-100"><i
                                                    class="fas fa-play" style="margin-left: 7px;"></i> مشاهده محتوای
                                            بیشتر</a>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                <?php
                endwhile;
                wp_reset_postdata(); // بازنشانی اطلاعات پست
            else :
                echo 'مطلبی یافت نشد.';
            endif;
            ?>

            <?php
            $video_posts = get_field('video_posts', 'option'); // بدست آوردن مقدار فیلد video_posts از تنظیمات گلوبال (option) در Advanced Custom Fields
            $category = get_term($video_posts, 'category'); // بدست آوردن اطلاعات دسته بندی براساس مقدار فیلد video_posts
            $post_count = $category->count; // تعداد پست‌های موجود در دسته بندی

            // نمایش لینک و تعداد پست‌ها
            ?>
            <div class="col-12 mt-4 text-center">
                <a href="<?php echo esc_url(get_category_link($video_posts)); ?>">
        <span class="align-items-center bg-primary-solid py-1 px-4 text-white rounded-pill d-inline-block small">
            <strong class="countup"><?php echo $post_count; ?></strong> - مشاهده همه ویدیو ها
        </span>
                </a>
            </div>

        </div>
    </div>
</section>
