<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">
            <h4 class="col-12 mb-1-9"><?php echo esc_html(get_field('ads_title', 'option')); ?>
                <svg class="header-line" width="178" height="7" viewBox="0 0 178 7" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <rect width="178" height="7" fill="#0189D0"/>
                </svg>
            </h4>
            <?php
            $taxon = get_field('ads', 'option');
            $args_all = array(
                'post_type' => 'post',
                'posts_per_page' => 5,
                'cat' => $taxon,
                'orderby' => 'date',
                'order' => 'DESC',
            );

            $query_all = new WP_Query($args_all);

            // Check if there are any posts
            if ($query_all->have_posts()) :
                $all_posts = $query_all->get_posts();

                // Separate posts into three sections
                $posts_left = array_slice($all_posts, 0, 2);
                $post_center = array_slice($all_posts, 2, 1);
                $posts_right = array_slice($all_posts, 3, 2);

                // Display left column posts
                ?>
                <div class="col-lg-3">
                    <?php foreach ($posts_left as $post) : setup_postdata($post); ?>
                        <div class="col-lg-12 pb-4">
                            <article class="blog-grid">
                                <div class="blog-grid-img position-relative">
                                    <img class="main-part-img" alt="<?php echo get_the_title(); ?>"
                                         src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>">
                                </div>
                                <div class="blog-grid-text p-4">
                                    <h3 class="h5 blog-item-title m-0"><a
                                                href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Display center column post -->
                <div class="col-lg-6 mb-2-0 mb-lg-0">
                    <?php foreach ($post_center as $post) : setup_postdata($post); ?>
                        <div class="blog-list-simple fadeInUp rtl wow" data-wow-delay=".2s">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="blog-list-simple-img">
                                        <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>"
                                             alt="<?php echo get_the_title(); ?>">
                                    </div>
                                    <div class="blog-list-simple-text">
                                        <h3 class="text-white">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>
                                        <p><?php echo get_the_excerpt(); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Display right column posts -->
                <div class="col-lg-3">
                    <?php foreach ($posts_right as $post) : setup_postdata($post); ?>
                        <div class="col-lg-12 pb-4">
                            <article class="blog-grid">
                                <div class="blog-grid-img position-relative">
                                    <img class="main-part-img" alt="<?php echo get_the_title(); ?>"
                                         src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>">
                                </div>
                                <div class="blog-grid-text p-4">
                                    <h3 class="h5 blog-item-title m-0"><a
                                                href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php
                // Reset post data
                wp_reset_postdata();
            endif;
            ?>
        </div>
    </div>
</section>
