<?php get_header(); ?>

<section class="page-title-section parallax primary-overlay-solid"
         data-background="<?php echo get_template_directory_uri() ?>/img/advertisers10.png">
    <div class="container lg-container">
        <div class="row">
            <div class="col-md-12 mt-1-8 rtl">
                <ul class="ps-0">
                    <li><a class="text-black" href="<?php echo esc_url(home_url('/')); ?>">خانه</a></li>
                    <li><a class="text-black"
                           href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">
            <!-- Blog Right -->
            <div class="col-lg-6">
                <div class="row">
                    <?php
                    // Query arguments for blog right
                    $blog_right_args = array(
                        'author' => get_the_author_meta('ID'),
                        'post_type' => 'post',
                        'posts_per_page' => 4 // تعداد پست‌های مورد نمایش
                    );

                    // The Query for blog right
                    $blog_right_query = new WP_Query($blog_right_args);

                    // The Loop for blog right
                    if ($blog_right_query->have_posts()) {
                        while ($blog_right_query->have_posts()) {
                            $blog_right_query->the_post();
                            ?>
                            <div class="col-lg-6 mb-4">
                                <article class="blog-grid">
                                    <div class="blog-grid-img position-relative"><img class="main-part-img"
                                                                                      alt="<?php the_title_attribute(); ?>"
                                                                                      src="<?php echo get_the_post_thumbnail_url(); ?>">
                                    </div>
                                    <div class="blog-grid-text p-4">
                                        <h3 class="h5 blog-item-title m-0"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    </div>
                                </article>
                            </div>
                            <?php
                        }
                        /* Restore original Post Data */
                        wp_reset_postdata();
                    } else {
                        // no posts found
                    }
                    ?>
                </div>
            </div>
            <!-- End Blog Right -->

            <!-- Blog Left -->
            <div class="col-lg-6 mb-2-9 mb-lg-0">
                <?php
                // Query arguments for blog left
                $blog_left_args = array(
                    'author' => get_the_author_meta('ID'),
                    'post_type' => 'post',
                    'posts_per_page' => 1 // تنها یک پست نمایش داده شود
                );

                // The Query for blog left
                $blog_left_query = new WP_Query($blog_left_args);

                // The Loop for blog left
                if ($blog_left_query->have_posts()) {
                    while ($blog_left_query->have_posts()) {
                        $blog_left_query->the_post();
                        ?>
                        <div class="blog-list-simple fadeInUp rtl wow" data-wow-delay=".2s">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="blog-list-simple-img"><img
                                                src="<?php echo get_the_post_thumbnail_url(); ?>"
                                                alt="<?php the_title_attribute(); ?>"></div>
                                    <div class="blog-list-simple-text">
                                        <h3 class="text-white"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p><?php echo get_the_excerpt() ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    /* Restore original Post Data */
                    wp_reset_postdata();
                } else {
                    // no posts found
                }
                ?>
            </div>
            <!-- End Blog Left -->
        </div>
    </div>
</section>

<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">
            <div class="carousel-style1 col-12 product-grid-style">
                <div class="product-grid grid-style-2 control-top owl-carousel owl-theme">
                    <?php
                    // Query arguments for posts by the author
                    $author_posts_args = array(
                        'author' => get_the_author_meta('ID'),
                        'post_type' => 'post',
                        'posts_per_page' => -1 // Retrieve all posts by the author
                    );

                    // The Query for posts by the author
                    $author_posts_query = new WP_Query($author_posts_args);

                    // The Loop for posts by the author
                    if ($author_posts_query->have_posts()) {
                        while ($author_posts_query->have_posts()) {
                            $author_posts_query->the_post();
                            ?>
                            <div>
                                <article class="blog-grid">
                                    <div class="blog-grid-img position-relative"><img class="main-part-img"
                                                                                      alt="<?php the_title_attribute(); ?>"
                                                                                      src="<?php echo get_the_post_thumbnail_url(); ?>">
                                    </div>
                                    <div class="blog-grid-text p-4">
                                        <span class="blog-item-category"><?php the_category(', '); ?></span>
                                        <h3 class="h5 blog-item-title"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <span class="blog-item-date"><?php echo get_the_date('j F Y'); ?></span>
                                    </div>
                                </article>
                            </div>
                            <?php
                        }
                        /* Restore original Post Data */
                        wp_reset_postdata();
                    } else {
                        // no posts found
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
