<?php
add_theme_support( 'post-thumbnails' );

function custom_excerpt_length( $length ) {
	return 10;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function wpb_custom_new_menu() {
	register_nav_menus(
		array(
			'main-menu' => __( 'Main menu' ),
			'extra-menu' => __( 'Extra Menu' )
		)
	);
}
add_action( 'init', 'wpb_custom_new_menu' );


// Register Custom Post Type
function websites_post_type() {

	$labels = array(
		'name'                  => _x( 'websites', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'website', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'websites', 'text_domain' ),
		'name_admin_bar'        => __( 'website', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Website:', 'text_domain' ),
		'all_items'             => __( 'All websites', 'text_domain' ),
		'add_new_item'          => __( 'Add New website', 'text_domain' ),
		'add_new'               => __( 'New website', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit website', 'text_domain' ),
		'update_item'           => __( 'Update website', 'text_domain' ),
		'view_item'             => __( 'View Website', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search websites', 'text_domain' ),
		'not_found'             => __( 'No websites found', 'text_domain' ),
		'not_found_in_trash'    => __( 'No websites found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'website', 'text_domain' ),
		'description'           => __( 'Website information pages.', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'website-cat' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => true,
		'capability_type'       => 'post',
		'show_in_rest'          => true,
	);
	register_post_type( 'website', $args );

}
add_action( 'init', 'websites_post_type', 0 );

// Register Custom Post Type
function customers_post_type() {

	$labels = array(
		'name'                  => _x( 'customers', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'customer', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'customers', 'text_domain' ),
		'name_admin_bar'        => __( 'customer', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Customer:', 'text_domain' ),
		'all_items'             => __( 'All customers', 'text_domain' ),
		'add_new_item'          => __( 'Add New customer', 'text_domain' ),
		'add_new'               => __( 'New customer', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit customer', 'text_domain' ),
		'update_item'           => __( 'Update customer', 'text_domain' ),
		'view_item'             => __( 'View customer', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search customers', 'text_domain' ),
		'not_found'             => __( 'No customers found', 'text_domain' ),
		'not_found_in_trash'    => __( 'No customers found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$rewrite2 = array(
		'slug'                       => 'customer',
		'with_front'                 => true,
		'hierarchical'               => false,
	);
	$args = array(
		'label'                 => __( 'customer', 'text_domain' ),
		'description'           => __( 'customer information pages.', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'customer-cat' ),

		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite2,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'customer', $args );

}
add_action( 'init', 'customers_post_type', 0 );

// Register Custom Taxonomy
function tax_Customer() {

	$labels = array(
		'name'                       => _x( 'Customers', 'Taxonomy General Name', 'text_domain' ),
		'singular_name'              => _x( 'Customer', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Categories', 'text_domain' ),
		'all_items'                  => __( 'All Customers', 'text_domain' ),
		'parent_item'                => __( 'Parent Customer', 'text_domain' ),
		'parent_item_colon'          => __( 'Parent Customer:', 'text_domain' ),
		'new_item_name'              => __( 'New Customer Name', 'text_domain' ),
		'add_new_item'               => __( 'Add New Customer', 'text_domain' ),
		'edit_item'                  => __( 'Edit Customer', 'text_domain' ),
		'update_item'                => __( 'Update Customer', 'text_domain' ),
		'view_item'                  => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate Customers with commas', 'text_domain' ),
		'add_or_remove_items'        => __( 'Add or remove Customers', 'text_domain' ),
		'choose_from_most_used'      => __( 'Choose from the most used Customers', 'text_domain' ),
		'popular_items'              => __( 'Popular Items', 'text_domain' ),
		'search_items'               => __( 'Search Customers', 'text_domain' ),
		'not_found'                  => __( 'Not Found', 'text_domain' ),
		'no_terms'                   => __( 'No items', 'text_domain' ),
		'items_list'                 => __( 'Items list', 'text_domain' ),
		'items_list_navigation'      => __( 'Items list navigation', 'text_domain' ),
	);
	$rewrite = array(
		'slug'                       => 'customer',
		'with_front'                 => true,
		'hierarchical'               => false,
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'rewrite'                    => $rewrite,
	);
	register_taxonomy( 'customer-cat', array( 'customer' ), $args );

}
add_action( 'init', 'tax_Customer', 0 );

// Register Custom Taxonomy
function website_taxonomy() {

	$labels = array(
		'name'                       => _x( 'websites', 'Taxonomy General Name', 'text_domain' ),
		'singular_name'              => _x( 'website', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Categories', 'text_domain' ),
		'all_items'                  => __( 'All websites', 'text_domain' ),
		'parent_item'                => __( 'Parent website', 'text_domain' ),
		'parent_item_colon'          => __( 'Parent website:', 'text_domain' ),
		'new_item_name'              => __( 'New website Name', 'text_domain' ),
		'add_new_item'               => __( 'Add New website', 'text_domain' ),
		'edit_item'                  => __( 'Edit website', 'text_domain' ),
		'update_item'                => __( 'Update website', 'text_domain' ),
		'view_item'                  => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate websites with commas', 'text_domain' ),
		'add_or_remove_items'        => __( 'Add or remove websites', 'text_domain' ),
		'choose_from_most_used'      => __( 'Choose from the most used websites', 'text_domain' ),
		'popular_items'              => __( 'Popular Items', 'text_domain' ),
		'search_items'               => __( 'Search websites', 'text_domain' ),
		'not_found'                  => __( 'Not Found', 'text_domain' ),
		'no_terms'                   => __( 'No items', 'text_domain' ),
		'items_list'                 => __( 'Items list', 'text_domain' ),
		'items_list_navigation'      => __( 'Items list navigation', 'text_domain' ),
	);
	$rewrite = array(
		'slug'                       => 'website',
		'with_front'                 => true,
		'hierarchical'               => false,
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'rewrite'                    => $rewrite,
	);
	register_taxonomy( 'website-cat', array( 'website' ), $args );

}
add_action( 'init', 'website_taxonomy', 0 );